***********************************************************************
UCC 220901 (PARKING) SHOULD BE IN OWN-DWELLING BUT IT IS NOT IN 1984
UCC'S 690242 & 690245 (HM FURNISHING) SHOULD NOT BE IN OWN-DWELLING 
BUT IT IS FOR 1984-86

12/13/07: CHANGED FROM GZIP MACRO TO USING GZIP COMMEND.
***********************************************************************;

LIBNAME mydat '~/jim/data';

*******  FAMILY FILES   **********;
 
filename mtab841 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0003-Data.txt.gz';
filename mtab842 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0007-Data.txt.gz';
filename mtab843 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0011-Data.txt.gz';
filename mtab844 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0015-Data.txt.gz';

filename mtab851 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0003-Data.txt.gz';
filename mtab852 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0007-Data.txt.gz';
filename mtab853 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0011-Data.txt.gz';
filename mtab854 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0015-Data.txt.gz';
filename mtab855 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0019-Data.txt.gz';

filename mtab861 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0003-Data.txt.gz';
filename mtab862 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0007-Data.txt.gz';
filename mtab863 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0011-Data.txt.gz';
filename mtab864 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0015-Data.txt.gz';

%MACRO read(qyr);
 
  DATA exp&qyr;
   INFILE mtab&qyr ;
   INPUT newid 1-8 ucc 9-14 cost 15-26;
IF ucc IN(220901,690242,690245);
   qyear=&qyr;
   IF qyear LE 855 THEN newid=9000000+newid;
  RUN;
 
PROC SORT; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     WHERE ucc IN(690242,690245); 
     VAR cost;
     OUTPUT OUT=hfurn&qyr(DROP=_TYPE_ _FREQ_) SUM=hfurn_adj;
RUN;
PROC MEANS; 
RUN;
PROC MEANS DATA=exp&qyr SUM NOPRINT; 
     BY newid;
     WHERE ucc=220901; 
     VAR cost;
     OUTPUT OUT=park&qyr(DROP=_TYPE_ _FREQ_) SUM=park_adj;
RUN;
PROC MEANS; 
RUN;

%MEND read;
 
%read(841);
%read(842);
%read(843);
%read(844);

%read(851);
%read(852);
%read(853);
%read(854);
%read(855);

%read(861);
%read(862);
%read(863);
%read(864);


DATA fix_own_dwell1;
   SET hfurn841 hfurn842 hfurn843 hfurn844
	hfurn851 hfurn852 hfurn853 hfurn854 hfurn855
	hfurn861 hfurn862 hfurn863 hfurn864;
RUN;
PROC SORT; 
   BY newid;
RUN; 
DATA fix_own_dwell2;
   SET park841 park842 park843 park844;
RUN;
PROC SORT; 
   BY newid;
RUN; 

DATA mydat.fix_own_dwell;
   MERGE fix_own_dwell1 fix_own_dwell2;
   BY newid;
RUN;

X "gzip -f ~/jim/data/fix_own_dwell.sas7bdat";


